USE DWDATA
go 
if exists (select * from sysobjects where id = object_id('CountCharactersInString'))
drop function CountCharactersInString
GO
/*
   -----------------------------------------------------------------------------
    www.how2assist.com,        Version 1.0,       Creation Date:  10/12/2010
    Created by : Juan Tenemaza                 
    Functionality: Count number of characters in string 
   -----------------------------------------------------------------------------
*/
CREATE FUNCTION CountCharactersInString
(
  @input_string nvarchar(max),
  @single_character nchar(1),
  @collation varchar(100)
)
	RETURNS int
	
	BEGIN
		DECLARE @count int

		IF @collation IS NULL
		  SELECT @count = LEN(@input_string) - LEN( REPLACE( @input_string, @single_character, ''))
		ELSE IF @collation = N'Latin1_General_CI_AI'
		  SELECT @count = LEN(@input_string) - LEN( REPLACE( @input_string COLLATE Latin1_General_CI_AI, @single_character COLLATE Latin1_General_CI_AI, '' ))

	RETURN @count

END

GO

-- Test 
-- select  dbo.CountCharactersInString(SUBJECT, N'?', NULL) as Total, SUBJECT from [DWDATA].[dbo].[SUPPORT_MAILBOX] where dbo.CountCharactersInString(SUBJECT, N'?', NULL) >= 5  order by 1